IF OBJECT_ID('EST_NF_SAI_PENDENCIA_CHECKIN_FORN') IS NULL
BEGIN

	CREATE TABLE [dbo].[EST_NF_SAI_PENDENCIA_CHECKIN_FORN](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_NF] [int] NOT NULL,
		[CD_FILIAL_DEST] [int] NOT NULL,
		[DT_REGISTRO] [datetime] NOT NULL,
	 CONSTRAINT [PK_EST_NF_SAI_PENDENCIA_CHECKIN_FORN] PRIMARY KEY NONCLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_NF] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
END

GO

IF OBJECT_ID('DF_EST_NF_SAI_PENDENCIA_CHECKIN_FORN_DT_REGISTRO') IS NULL
BEGIN
	ALTER TABLE [dbo].[EST_NF_SAI_PENDENCIA_CHECKIN_FORN] ADD  CONSTRAINT [DF_EST_NF_SAI_PENDENCIA_CHECKIN_FORN_DT_REGISTRO]  DEFAULT (CONVERT([varchar],getdate(),(120))) FOR [DT_REGISTRO]
END

GO

IF OBJECT_ID('FK_EST_NF_SAI_PENDENCIA_CHECKIN_FORN_EST_NF_SAI') IS NULL
BEGIN
	ALTER TABLE [dbo].[EST_NF_SAI_PENDENCIA_CHECKIN_FORN]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_PENDENCIA_CHECKIN_FORN_EST_NF_SAI] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
	REFERENCES [dbo].[EST_NF_SAI] ([CD_EMP], [CD_FILIAL], [CD_NF])
	ON UPDATE CASCADE
	ON DELETE CASCADE

	ALTER TABLE [dbo].[EST_NF_SAI_PENDENCIA_CHECKIN_FORN] CHECK CONSTRAINT [FK_EST_NF_SAI_PENDENCIA_CHECKIN_FORN_EST_NF_SAI]
END
GO
